;	Fr AutoCAD Version 2023
;	Nicht getestet unter ltern Versionen, in denen kann es aufgrund von internen
;	Befehls-nderungen zu unerwarteten Reaktionen kommen.
;	Dateiname: dr_klappe_s.lsp - erstellt: 10.06.2023- Dieter Ribbrock
;	http://www.ribbrock-online.de
;	Datei erstellt eine Klappenkonstruktionen mit seitlich abgeschrgter Klappenkante
;	Aufruf:	dr_klappe_s
;
;	Das Programm wird dem Benutzer - "in dieser Form" - zur Verfgung gestellt.
;	Fr eventuelle Programmfehler oder Schden durch die Anwendung wird keine Haftung bernommen.
;
;	Erforderliche Eingaben:
;	PP		Platzierpunkt <Punkt> <PP> = siehe Markierungen in Dias
;
;	D1		Materialdicke Seite
;	D2		Materialdicke Platte
;	D3		Materialdicke Anleimer
;	Lm		Lnge Material
;	Fm1		Fasenma 1 Abschrgung Stirnseitig
; 	Fm2		Fasenma 2 Abschrgung Lngsseitig
;	KZ		Text fr Materialbezeichnung
;
;-------------------------------------------------------------------------
; Unterprogramme f0 bis f3 zur jeweiligen Klappenkonstruktion
;-------------------------------------------------------------------------
(defun f0 ()										;
	(setq PP (getpoint "\nGeben Sie den Platzierpunkt an:"))
    
	(setq P1 (polar PP (aib 90) Lm))	;
	(setq P2 (polar PP (aib 180) D1))	;
	(setq P3 (polar P2 (aib 90) Lm))	;
	(setq P4 (polar PP (aib 0) Lm))		;
  	(setq P5 (polar P2 (aib 270) D2))	;
	(setq P6 (polar P5 (aib 0) (+ D1 Lm)))	;
  	(setq P7 (polar P5 (aib 90) Fm1))	;
  	(setq P8 (polar P5 (aib 0) Fm2))	;
 
  	(setq P21 (polar PP (aib 90) D3))
 	(setq P22 (polar P2 (aib 90) D3))
	(setq P23 (polar P2 (aib 0) D3))
	(setq P24 (polar P23 (aib 270) D2))

   	(setq P9 (inters P23 P24 P7 P8))	;

	(setq P25 (polar P9 (aib 90) (/ (distance P9 P23)2)))	;
	(setq P26 (polar P22 (aib 0) (/ D1 2.0)))		;
  

      	(setq PT1 (polar P2 (angle P2 P6) (/ (distance P2 P6)2)))	;
 	(setq PT2 (polar P2 (angle P2 P1) (/ (distance P2 P1)2)))	;

  	(setq PS3 (polar P25 (aib 0) 5))	;
	(setq PS4 (polar P26 (aib 90) 5))  	;

	(setq P41 (polar PP (aib 180) 1))		;
	(setq P42 (polar P41 (aib 90) 30))
	(setq P43 (polar P2 (aib 0) 1))
	(setq P44 (polar P43 (aib 90) 30))
  
	(command "LAYER" "M" "LT-A" "FA" "7" "LT-A" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

  	(command "PLinie" P1 PP P2 P3 "")
  	(command "Abrunden" "P" "R" "0" "L")
  
	(command "PLinie" P4 P2 P7 P8 P6 "")	;
    	(command "Abrunden" "P" "R" "0" "L")

	(command "Linie" P21 P22 "")
	(command "Linie" P23 P9 "")		;

    	(command "LAYER" "M" "LT-Text" "FA" "2" "LT-Text" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
      	(command "text" "I" "mz" PT1 "2.5" "0" KZ)		;
      	(command "text" "I" "mz" PT2 "2.5" "90" KZ)

  	(command "LAYER" "M" "LT-Schraffur" "FA" "41" "LT-Schraffur" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

 	(command "PLinie" P9 P8 P6 P4 P23 "S")(setq PL1 (entlast))  ;
 	(command "PLinie" P21 P1 P3 P22 "S")(setq PL2 (entlast))  ;

 	(command "-schraff" "ei" "plasti" 1 45 "C" "N" P2 P7 P9 P23 "S" "" "")	;
  	(command "-schraff" "ei" "plasti" 1 135 "C" "N" P2 PP P21 P22 "S" "" "")

  	(command "-schraff" "ei" "ansi31" 2.5 45 PS3 "")    ;
  	(command "-schraff" "ei" "ansi31" 2.5 135 PS4 "")   ;
	      
  	(if (= Kon 1)					;
		(progn
      	(command "LAYER" "M" "LT-B" "FA" "3" "LT-B" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
	(command "Linie" P41 P42 "")
	(command "Linie" P43 P44 "")
		)
	)
  
  	(if (= Zog 1) (progn (zogr)))

	(command "_.erase" PL1 PL2 "")                          ;
  
)							;
;-------------------------------------------------------------------------
(defun f1 ()										;
	(setq PP (getpoint "\nGeben Sie den Platzierpunkt an:"))
  
	(setq P1 (polar PP (aib 90) Lm))		;
	(setq P2 (polar PP (aib 0) D1))			;
	(setq P3 (polar P2 (aib 90) Lm))		;
	(setq P4 (polar PP (aib 180) Lm))		;
  	(setq P5 (polar P2 (aib 270) D2))		;
	(setq P6 (polar P5 (aib 180) (+ D1 Lm)))	;
    	(setq P7 (polar P5 (aib 90) Fm1))		;
  	(setq P8 (polar P5 (aib 180) Fm2))		;

  	(setq P21 (polar PP (aib 90) D3))
 	(setq P22 (polar P2 (aib 90) D3))
	(setq P23 (polar P2 (aib 180) D3))
	(setq P24 (polar P23 (aib 270) D2))

     	(setq P9 (inters P23 P24 P7 P8))		;

  	(setq P25 (polar P9 (aib 90) (/ (distance P9 P23)2)))	;
	(setq P26 (polar P22 (aib 180) (/ D1 2.0)))		;
  

      	(setq PT1 (polar P2 (angle P2 P6) (/ (distance P2 P6)2)))	;
 	(setq PT2 (polar P2 (angle P2 P1) (/ (distance P2 P1)2)))	;

  	(setq PS3 (polar P25 (aib 180) 5))	;
	(setq PS4 (polar P26 (aib 90) 5))  	;

	(setq P41 (polar PP (aib 0) 1))			;
	(setq P42 (polar P41 (aib 90) 30))
	(setq P43 (polar P2 (aib 180) 1))
	(setq P44 (polar P43 (aib 90) 30))
  
	(command "LAYER" "M" "LT-A" "FA" "7" "LT-A" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

  	(command "PLinie" P1 PP P2 P3 "")
  	(command "Abrunden" "P" "R" "0" "L")
  
	(command "PLinie" P4 P2 P7 P8 P6 "")		;
    	(command "Abrunden" "P" "R" "0" "L")

	(command "Linie" P21 P22 "")
	(command "Linie" P23 P9 "")			;

    	(command "LAYER" "M" "LT-Text" "FA" "2" "LT-Text" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
      	(command "text" "I" "mz" PT1 "2.5" "0" KZ)		;
      	(command "text" "I" "mz" PT2 "2.5" "90" KZ)

  	(command "LAYER" "M" "LT-Schraffur" "FA" "41" "LT-Schraffur" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

 	(command "PLinie" P23 P9 P8 P6 P4 "S")(setq PL1 (entlast))  ;
 	(command "PLinie" P21 P1 P3 P22 "S")(setq PL2 (entlast))  ;

  	(command "-schraff" "ei" "plasti" 1 135 "C" "N" P2 P7 P9 P23 "S" "" "")
 	(command "-schraff" "ei" "plasti" 1 45 "C" "N" P2 PP P21 P22 "S" "" "")

	(command "-schraff" "ei" "ansi31" 2.5 45 PS3 "")    ;
  	(command "-schraff" "ei" "ansi31" 2.5 135 PS4 "")   ;
  
  	(if (= Kon 1)					;
		(progn
      	(command "LAYER" "M" "LT-B" "FA" "3" "LT-B" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
	(command "Linie" P41 P42 "")
	(command "Linie" P43 P44 "")
		)
	)
   	(if (= Zog 1) (progn (zogr)))

 	(command "_.erase" PL1 PL2 "")                          ;
)
;-------------------------------------------------------------------------
(defun f2 ()										;

	(setq PP (getpoint "\nGeben Sie den Platzierpunkt an:"))
    
	(setq P1 (polar PP (aib 90) Lm))	;
	(setq P2 (polar PP (aib 180) D1))	;
	(setq P3 (polar P2 (aib 90) Lm))	;
	(setq P4 (polar PP (aib 0) Lm))		;
  	(setq P5 (polar P2 (aib 270) D2))	;
	(setq P6 (polar P5 (aib 0) (+ D1 Lm)))	;
    	(setq P7 (polar P5 (aib 90) Fm1))	;
  	(setq P8 (polar P5 (aib 0) Fm2))	;
 
  	(setq P21 (polar PP (aib 90) D3))
 	(setq P22 (polar P2 (aib 90) D3))
	(setq P23 (polar P2 (aib 0) D3))
	(setq P24 (polar P23 (aib 270) D2))

     	(setq P9 (inters P23 P24 P7 P8))	;

  	(setq P25 (polar P9 (aib 90) (/ (distance P9 P23)2)))	;
	(setq P26 (polar P22 (aib 0) (/ D1 2.0)))		;

      	(setq PT1 (polar P2 (angle P2 P6) (/ (distance P2 P6)2)))	;
 	(setq PT2 (polar P2 (angle P2 P1) (/ (distance P2 P1)2)))	;

  	(setq PS3 (polar P25 (aib 0) 5))	;
	(setq PS4 (polar P26 (aib 90) 5))  	;
  
	(setq P41 (polar PP (aib 180) 1))		;
	(setq P42 (polar P41 (aib 90) 1))
  	(setq P43 (polar P41 (aib 90) 30))
	(setq P44 (polar P2 (aib 0) 1))
	(setq P45 (polar P44 (aib 90) 1))
  	(setq P46 (polar P44 (aib 90) 30))
	(setq P47 (polar PP (aib 90) 1))
  	(setq P48 (polar P2 (aib 90) 1))

	(command "LAYER" "M" "LT-A" "FA" "7" "LT-A" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

  	(command "PLinie" P1 PP P2 P3 "")
  	(command "Abrunden" "P" "R" "0" "L")
  
	(command "PLinie" P4 P2 P7 P8 P6 "")	;
    	(command "Abrunden" "P" "R" "0" "L")

	(command "Linie" P23 P9 "")		;
  
    	(command "LAYER" "M" "LT-Text" "FA" "2" "LT-Text" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
      	(command "text" "I" "mz" PT1 "2.5" "0" KZ)		;
      	(command "text" "I" "mz" PT2 "2.5" "90" KZ)

  	(command "LAYER" "M" "LT-Schraffur" "FA" "41" "LT-Schraffur" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

	(command "PLinie" P9 P8 P6 P4 P23 "S")(setq PL1 (entlast))  ;
 	(command "PLinie" P2 PP P1 P3 "S")(setq PL2 (entlast))  ;

 	(command "-schraff" "ei" "plasti" 1 45 "C" "N" P2 P7 P9 P23 "S" "" "")	;
  
  	(command "-schraff" "ei" "ansi31" 2.5 45 PS3 "")    ;
  	(command "-schraff" "ei" "ansi31" 2.5 135 PS4 "")   ;
	      
    	(if (= Kon 1)					;
		(progn
      	(command "LAYER" "M" "LT-B" "FA" "3" "LT-B" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")

	(command "Linie" P42 P43 "")	;
	(command "Linie" P45 P46 "")	;
	(command "Linie" P47 P48 "")	;
		)
	)
  
	(if (= Zog 1) (progn (zogr)))

  	(command "_.erase" PL1 PL2 "")                          ;
  
)
;-------------------------------------------------------------------------
(defun f3 ()										;

  	(setq PP (getpoint "\nGeben Sie den Platzierpunkt an:"))
  
	(setq P1 (polar PP (aib 90) Lm))		;
	(setq P2 (polar PP (aib 0) D1))			;
	(setq P3 (polar P2 (aib 90) Lm))		;
	(setq P4 (polar PP (aib 180) Lm))		;
  	(setq P5 (polar P2 (aib 270) D2))		;
	(setq P6 (polar P5 (aib 180) (+ D1 Lm)))	;
      	(setq P7 (polar P5 (aib 90) Fm1))	;
  	(setq P8 (polar P5 (aib 180) Fm2))	;

  	(setq P21 (polar PP (aib 90) D3))
 	(setq P22 (polar P2 (aib 90) D3))
	(setq P23 (polar P2 (aib 180) D3))
	(setq P24 (polar P23 (aib 270) D2))

       	(setq P9 (inters P23 P24 P7 P8))	;

    	(setq P25 (polar P9 (aib 90) (/ (distance P9 P23)2)))	;
	(setq P26 (polar P22 (aib 180) (/ D1 2.0)))		;
  
      	(setq PT1 (polar P2 (angle P2 P6) (/ (distance P2 P6)2)))	;
 	(setq PT2 (polar P2 (angle P2 P1) (/ (distance P2 P1)2)))	;

  	(setq PS3 (polar P25 (aib 180) 5))	;
	(setq PS4 (polar P26 (aib 90) 5))  	;

	(setq P41 (polar PP (aib 0) 1))			;
	(setq P42 (polar P41 (aib 90) 1))
  	(setq P43 (polar P41 (aib 90) 30))
	(setq P44 (polar P2 (aib 180) 1))
	(setq P45 (polar P44 (aib 90) 1))
  	(setq P46 (polar P44 (aib 90) 30))
	(setq P47 (polar PP (aib 90) 1))
  	(setq P48 (polar P2 (aib 90) 1))

	(command "LAYER" "M" "LT-A" "FA" "7" "LT-A" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

  	(command "PLinie" P1 PP P2 P3 "")
  	(command "Abrunden" "P" "R" "0" "L")
  
	(command "PLinie" P4 P2 P7 P8 P6 "")	;
    	(command "Abrunden" "P" "R" "0" "L")

	(command "Linie" P23 P9 "")

    	(command "LAYER" "M" "LT-Text" "FA" "2" "LT-Text" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
      	(command "text" "I" "mz" PT1 "2.5" "0" KZ)		;
      	(command "text" "I" "mz" PT2 "2.5" "90" KZ)

  	(command "LAYER" "M" "LT-Schraffur" "FA" "41" "LT-Schraffur" "")
	(command "LAYER" "LT" "CONTINUOUS" "" "")

  	(command "PLinie" P23 P4 P6 P8 P9 "S")(setq PL1 (entlast)) 	 ;
  	(command "PLinie" P2 P3 P1 PP "S")(setq PL2 (entlast)) 		 ;

   	(command "-schraff" "ei" "plasti" 1 135 "C" "N" P2 P7 P9 P23 "S" "" "")	;

  	(command "-schraff" "ei" "ansi31" 2.5 45 PS3 "")    ;
  	(command "-schraff" "ei" "ansi31" 2.5 135 PS4 "")   ;
	      
  	(if (= Kon 1)					;
		(progn
      	(command "LAYER" "M" "LT-B" "FA" "3" "LT-B" "")	;
	(command "LAYER" "LT" "CONTINUOUS" "" "")
	
	(command "Linie" P42 P43 "")	;
	(command "Linie" P45 P46 "")	;
	(command "Linie" P47 P48 "")	;
		)
	)
  
	(if (= Zog 1) (progn (zogr)))

  	(command "_.erase" PL1 PL2 "")                          ;

)
;-------------------------------------------------------------------------
;
(defun zogr ()
	(command "_zoom" "fe" P3 P6)		;
  	(command "_zoom" "fa" ".95xp")
)
(princ)
;-------------------------------------------------------------------------
;
(defun aib (w)
	(* Pi (/ w 180.0))
)
;-------------------------------------------------------------------------
; Unterprogramm AUSFUEHRUNG
(defun ausfuehrung ()
	(setq cealt (getvar "CMDECHO"))		; 
	(setq mealt (getvar "MENUECHO"))	; 
	(setq layalt (getvar "CLAYER"))		; 
	(setq bpm (getvar "BLIPMODE"))		; 
 	(setq osm (getvar "OSMODE"))		; 
	(setq pdm (getvar "PDMODE"))		; 
	(setvar "CMDECHO" 0)
	(setvar "MENUECHO" 0)
	(setvar "OSMODE" 0)
	(setvar "BLIPMODE" 0)
  	(setvar "PDMODE" 3)
  
;
  
 (if (= bildwahl "0")(progn (f0)))
 (if (= bildwahl "1")(progn (f1)))
 (if (= bildwahl "2")(progn (f2)))
 (if (= bildwahl "3")(progn (f3)))

;
 (setq ja nil)
 (altsave)  
)
;
;-------------------------------------------------------------------------
;
(defun *error* (emsg)
	(princ emsg)
	(altsave)
	(princ)
)
;
;-------------------------------------------------------------------------
;
(defun altsave ()
	(command "Layer" "SE" layalt "")
	(setvar "CMDECHO" cealt)
	(setvar "MENUECHO" mealt)
	(setvar "BLIPMODE" bpm)
	(setvar "OSMODE" osm)
  	(setvar "PDMODE" pdm)			; Neu 19.01
)
;-------------------------------------------------------------------------
;Unterprogramm
(defun listbox ()
(schalter)
(setq lb_drklappe (get_tile "lb"))
(setq breite (dimx_tile "bild"))
(setq hoehe (dimy_tile "bild"))
(start_image "bild")
(fill_image 0 0 breite hoehe -2)
(slide_image 0 0 breite hoehe (strcat "dr_klappe_s(dia" lb_drklappe ")"))	;
(end_image)
)
;-------------------------------------------------------------------------
;Unterprogramm
(defun imagebutton_unten ()
(setq isd_string (get_tile "lb"))
(setq isd_integer (atoi isd_string))
(setq isd_integer_next_string (itoa (+ isd_integer 1)))
(set_tile "lb" isd_integer_next_string)
(setq breite (dimx_tile "bild"))
(setq hoehe (dimy_tile "bild"))
(start_image "bild")
(fill_image 0 0 breite hoehe -2)
(slide_image 0 0 breite hoehe (strcat "dr_klappe_s(dia" isd_integer_next_string ")"))
(end_image)
  
(if (= isd_integer (- listenelemente 1))
 (progn
 (set_tile "lb" "0")									;
 (start_image "bild")
 (fill_image 0 0 breite hoehe -2)
 (slide_image 0 0 breite hoehe "dr_klappe_s(dia0)")
 (end_image)
 )
)
(setq lb_drklappe (get_tile "lb"))							;
(schalter)
)
;-------------------------------------------------------------------------
;Unterprogramm
(defun imagebutton_oben ()
(setq isd_string (get_tile "lb"))							;
(setq isd_integer (atoi isd_string))
(setq isd_integer_next_string (itoa (- isd_integer 1)))
(set_tile "lb" isd_integer_next_string)							;
(setq breite (dimx_tile "bild"))
(setq hoehe (dimy_tile "bild"))
(start_image "bild")
(fill_image 0 0 breite hoehe -2)
(slide_image 0 0 breite hoehe (strcat "dr_klappe_s(dia" isd_integer_next_string ")"))
(end_image)
  
(if (= isd_integer 0)
 (progn
 (set_tile "lb" (itoa (- listenelemente 1)))						;
 (start_image "bild")
 (fill_image 0 0 breite hoehe -2)
 (slide_image 0 0 breite hoehe (strcat "dr_klappe_s(dia" (itoa (- listenelemente 1)) ")"))
 (end_image)
 )
)
(setq lb_drklappe (get_tile "lb"))							;
(schalter)
)										;
;-------------------------------------------------------------------------
;Unterprogramm
;
(defun pickpunkt (y)
(setq halbe_hoehe (/ (dimy_tile "bild") 2.0))
(if (> y halbe_hoehe)
 (imagebutton_unten))
(if (< y halbe_hoehe)
(imagebutton_oben))
)										;
;-------------------------------------------------------------------------
;Unterprogramm
(defun okay ()
(setq bildwahl (get_tile "lb"))							;
(setq ja (done_dialog 1))
)
;-------------------------------------------------------------------------
;Unterprogramm
(defun abbruch ()
(done_dialog 0)
)
;-------------------------------------------------------------------------
;Unterprogramm
(defun dcl_box ()
(setq dcl_kennzahl (load_dialog "DR_KLAPPE_S.dcl"))	;
(setq nd (new_dialog "dr_klappen" dcl_kennzahl))

;Fllen der "LIST_BOX"
(start_list "lb" 3)					;
(mapcar 'add_list liste)				;
(end_list)

;Setzen der Erffnungseinstellungen
(setq lb_drklappe "0")				;
(set_tile "lb" lb_drklappe)

(setq breite (dimx_tile "bild"))
(setq hoehe (dimy_tile "bild"))
(start_image "bild")
(fill_image 0 0 breite hoehe -2)
(slide_image 0 0 breite hoehe (strcat "dr_klappe_s(dia" lb_drklappe ")"))
(end_image)
  
(start_image "LOGO")				;
(slide_image 25 5 150 100 "dr_klappe_s(logo)")	;
(end_image)

(set_tile "DD1" (rtos D1 2 0))			;
   
(set_tile "DD2" (rtos D2 2 0))			;

(set_tile "DKon" (rtos Kon 2 0))		;

(set_tile "DZog" (rtos Zog 2 0))		;
(setq Zog (atoi (get_tile "DZog")))		;

(set_tile "DD3" (rtos D3 2 0))			;

(set_tile "DLm" (rtos Lm 2 0))			;

(set_tile "DFm1" (rtos Fm1 2 0))		;
(set_tile "DFm2" (rtos Fm2 2 0))		;
  
(setq KZ (get_tile "DKZ"))			;
  
;Zuweisung der Aktionen

(action_tile "DD1" "(setq D1 (atof $value))")	;
(action_tile "DD2" "(setq D2 (atof $value))")
(action_tile "DD3" "(setq D3 (atof $value))")
(action_tile "DLm" "(setq Lm (atof $value))")

(action_tile "DFm1" "(setq Fm1 (atof $value))")  
(action_tile "DFm2" "(setq Fm2 (atof $value))")  

(action_tile "DKZ" "(do_txt)")    
  
(action_tile "DKon" "(setq Kon (atoi $value))")	;
(action_tile "DZog" "(setq Zog (atoi $value))") ;
(action_tile "lb" "(listbox)")
(action_tile "bild" "(pickpunkt $y)")
(action_tile "cancel" "(abbruch)")
(action_tile "accept" "(okay)")

(start_dialog)					;
(unload_dialog dcl_kennzahl)			;
)						;
;------------------------------------------------
(defun do_txt ()				;
  (setq KZ (get_tile "DKZ"))
)  
;-------------------------------------------------------------------------
; Unterprogramm
;
(defun schalter ()
(setq bildwahl (get_tile "lb"))
  (if (= bildwahl "0")(progn (mode_tile "DD3" 0)				;
			(setq D3 5)
			(set_tile "DD3" (rtos D3 2 0))
  		      ))
  (if (= bildwahl "1")(progn (mode_tile "DD3" 0)				;
			(setq D3 5)
			(set_tile "DD3" (rtos D3 2 0))
			))
  (if (= bildwahl "2")(progn (mode_tile "DD3" 0)				;
  			(setq D3 5)						;
			(set_tile "DD3" (rtos D3 2 0))
			))
  (if (= bildwahl "3")(progn (mode_tile "DD3" 0)				;
  			(setq D3 5)
			(set_tile "DD3" (rtos D3 2 0))
			))
)
;
;-------------------------------------------------------------------------
;Hauptprogramm dr_klappe_s
(defun c:dr_klappe_s ( / PP P1 P2 P3 P4 P5 P6 P7 P8 P9 P21 P22 P23 P24 PS1 PT1 PS2 PT2 win1 LP14 P41 P42 P43 P44 P45 P46 P47 P48
			cealt mealt layalt bpm osm pdm ja lb_drklappe breite hoehe isd_string isd_integer isd_integer_next_string halbe_hoehe bildwahl
			dcl_kennzahl nd Zog KZ D1 D2 D3 Lm Fm1 Fm2 Kon liste listenelemente)
 
  	(setq D1 19)	;
	(setq D2 19)	;
	(setq D3 5)	;
  	(setq Lm 60)	;
  	(setq Fm1 5)	;
  	(setq Fm2 20)	;
  
	(setq Kon 1)	;
  	(setq Zog 0)	;
  
;
(setq liste (list "Seite mit Massivanleimer - links" "Seite mit Massivanleimer - rechts" "Seite bekantet - links" "Seite bekantet - rechts"))
  
(setq listenelemente (length liste))			;
(dcl_box)						;

(if (/= ja nil)	(ausfuehrung))				;
(redraw)						;
(princ)
)							;
(princ "\n Copyright (c) 2o23 Dieter Ribbrock.")
(princ "\n Das Programm dr_klappe_s.lsp ist geladen. Mit Eingabe dr_klappe_s und RETURN starten.")
(princ)
